<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="preload" href="{{ asset('images/Home Page Website.jpg') }}" as="image">
<link rel="icon" href="{{ asset('images/favicon.png') }}" type="image/x-icon">
<link href="{{ asset('css/Home AR.css') }}" rel="stylesheet">

    <title>EdTech Plus - Learning with a Difference</title>
  
</head>
<body>


<div id="preloader">
  <div id="logo-container">
  <img src="{{ asset('images/Edtech-logo.png') }}" alt="Logo">
  </div>
</div>

 <button id="back-to-top" style="display: none;" class="scroll-top-button">&#9650;</button>

 @include('HeaderAR')

    <div class="backgroundimage">
<img src="{{ asset('images/Home Page Website.jpg') }}" alt="Main Image">
</div>
    
    <div class="container">
        <div class="card">
            <img class="logo" src="{{ asset('images/edtech-plus-icons-02.webp') }}" alt="Card 1 Logo">
            <div>
                <h2>SPEAK THE WORLD</h2>
                <p>with Our Language Courses!</p>
                <a href="{{ route('courses') }}">VIEW COURSES</a>
            </div>
        </div>
        
        <div class="card">
            <img class="logo" src="{{ asset('images/edtech-plus-icons-02.webp') }}" alt="Card 2 Logo">
            <div>
                <h2>CODE YOUR DREAMS</h2>
                <p>with Our Coding and Robotics Courses!</p>
                <a href="{{ route('courses') }}">VIEW COURSES</a>
            </div>
        </div>
    </div>
    <br><br>
    <div class="center-text">
        EdTech Plus Ltd: Elevating Global Education for Tomorrow's Leaders.
    </div>
    <br><br><br>
<br>
    <table style="border-collapse: collapse;">
        <tr>
            <td class="left-column additional-text">
                EdTech Plus Ltd., headquartered in London, launched its global "EdTech Plus" brand  
                for Innovation and Development of education implemented in over 21 countries.<br><br>
                
                We offer a comprehensive hybrid solution that enhances learning, enabling analytical and critical thinking 

and providing engaging digital 
                experiences.<br><br>
                
                
                EdTech Plus provides a wide range of innovative EdTech solutions in various subjects including Languages, 

Coding, Robotics, STEAM, and 3D 
                printing 
                and much more. <br><br>
                
                
                EdTech Plus provides an all-inclusive package: hardware, software, digital K-12 curriculum, lesson plans, 

workbooks, and teacher training. <br><br>
                
                
                At our core, we strive to make schools technologically adept, benchmarking against the world's educational 

vanguards.<br><br>
                
                
                Drawing upon 34 years of educational prowess, our mission transcends conventional ed-tech solutions. We 

believe in sculpting students into 
                global 
                communicators and technological trailblazers.<br><br>
                
                <b>Our Two-Pronged Approach:</b><br><br>
                

                <b>EdTech Plus Language Learning (Linguistic Mastery):</b><br>
                Using advanced neural networks and adaptive mechanisms, we have created a next-gen language-learning arena. 

Our courses, accredited by the EdTech Plus 
                Institute in London, span English, Spanish, French, and Arabic.
                We foster multi-lingual proficiency, paving the path for students to graduate with command over multiple 

languages. This multi-lingual approach not only 
                enriches their global perspective but also emboldens them as global communicators.<br><br>
                

                <b>EdTech Plus Technology Empowerment:</b><br>
                
                Our curricula cover the entire gamut of future-ready subjects, from Coding, Robotics, STEAM to 3D printing, 

setting our students on the frontlines of 
                tech 
                innovations. Our state-of-the-art methodologies and tools, propel students from theory to tangible 

innovations, addressing real-world challenges.<br><br>
                

                Unparalleled Security and Access: Our digital platforms, usable across various devices, prioritize student 

safety. A stringent security protocol ensures 
                that our learners are shielded from inappropriate content and potential cyber threats. With individualized 

access, students can explore a treasure trove 
                of 
                resources, securely, anytime, anywhere.<br><br>
                

                Our Outreach: Having partnered with over 500 esteemed educational institutions globally, our solutions are 

finely tuned, drawing from diverse 
                educational 
                practices. Our dedicated international team remains vigilant, aligning with the latest in pedagogical 

innovations.<br><br>
                

                In a world of incessant technological flux, we champion resilience and adaptability, prepping our students to 

not just adapt but to lead and innovate. 
                Join 
                us in this revolutionary journey, sculpting tomorrow's leaders, today.
            </td>
            <td class="right-column">
                <div class="video-container">
                        <iframe width="560" height="315" src="https://www.youtube.com/embed/icFmABwbWMU" frameborder="0" allowfullscreen></iframe>         
                </div>
                <br>
               
               
            </td>
        </tr>
    </table>


             <td>
<div class="popular-courses">
    <h2><b>Popular Courses</b></h2>
</div>
</td>

     
<div class="scroll-container">
<table>

        <tr>
            <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/Online-Linguaphone-Complete-English-4-scaled-1024x813-1.webp') }}"
                        alt="Course 1 Image" width="300">
                    <p>LINGUAPHONE UK</p>
                    <h2>Online Linguaphone
                        <br>Complete English  Fully Digital Course  All Levels (1,2,3,4,5,6,7,8,9)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        284 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        19573298 <span class="price">$<b style="color: orange;">1,250.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <!-- Repeat the same structure for other courses -->

            <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/English-L1-scaled.webp') }}" alt="Course 2 Image" width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete English  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        22 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                       15786441 <span class="price">$<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/English-cover.webp') }}" alt="Course 3 Image" width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete English  Fully Digital Course  All Levels (Foundation + 8 Levels)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        68 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                       15786430 <span class="price">$<b style="color: orange;">2,000.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

            <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/English-for-kids-L1-scaled.webp') }}" alt="Course 4 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>English for Kids  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        105 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        498083 <span class="price"> $<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

 <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/ENGLISH-FOR-KIDS-DESIGN-EDTECH-PLUS-LANGUAGES-0723.webp') }}" alt="Course 5 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>English for Kids  Fully Digital Course  All Levels (1, 2, 3)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        131 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        498067 <span class="price"> $<b style="color: orange;">1,200.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

 <td class="coursescard">
                <a href="{{ route('courses') }}"
                    rel="bookmark">
                    <img src="{{ asset('images/Spanish-L1-scaled.webp') }}" alt="Course 6 Image"
                        width="300">
                    <p>EdTech Plus</p>
                    <h2>EdTech Plus
                        <br>Complete Spanish  Fully Digital Course  Level (1)</h2>
                    <div class="numbers">
                        <span class="logo-paper">&#128196;</span> <!-- Paper icon -->
                        22 <!-- Number -->
                        <span class="logo-profile">&#128100;</span> <!-- Profile icon -->
                        213775 <span class="price"> $<b style="color: orange;">400.00</b></span> <!-- Price -->
                    </div>
                </a>
            </td>

        </tr>
    </table>
</div>

  <div class="events-container">
        <div class="events">
            <h1>Events: Upcoming Education Events to Feed Your Brain</h1>
            <div class="view-all">
                <a href="{{ route('events') }}">View All</a>
            </div>
            <div class="event">
                <div class="event-text">
                    <h2><a href="{{ route('events') }}">BETT SHOW UK 2020</a></h2>
                    <p class="date">23 October</p>
                    <p class="location">London</p>
                    <p>8:00 AM - 5:00 PM</p>
                    <p>You are cordially invited to visit our British sister company "Professional Learning Center LTD." at Bett Show UK 2020. Join us at our Stand...</p>
                </div>
                <img class="event-image" src="{{ asset('images/edtech-bett2-1-scaled-1.webp') }}" alt="Event 1 Image">
            </div>
            <div class="event">
                <div class="event-text">
                    <h2><a href="{{ route('events') }}">HIGH-LEVEL LEBANON-UK TECH FORUM</a></h2>
                    <p class="date">15 March</p>
                    <p class="location">London</p>
                    <p>12:00 AM - 5:00 PM</p>
                    <p>PLC- Professional Learning Center is honored to be the only Lebanese institute mentioned in the closing speech of the British Ambassador to Lebanon HMA...</p>
                </div>
                <img class="event-image" src="{{ asset('images/tech-forum.webp') }}" alt="Event 2 Image">
            </div>
            <!-- Add more events here if needed -->
        </div>
    </div>
<br>
<br>
<br>



</div>

@include('Footer')
    



<script src="{{ asset('js/Home AR.js') }}"></script>

<script>
 document.addEventListener('DOMContentLoaded', function () {
        var navbar = document.getElementById('navbar');
        var navLinks = document.querySelectorAll('.navbar a');
        var logoImage = document.getElementById('navbar-logo');
        var languageLinks = document.querySelectorAll('.dropdown-content a'); // Select language menu links
        var languageText = document.querySelectorAll('.selected-text');
  var hamburger = document.querySelectorAll('.hamburger');
  var dropdown = document.querySelectorAll('.dropdown-icon');


  var initialLogoSrc = '{{ asset('images/Edtech-logo-white-01-768x151-1.png') }}';
var scrolledLogoSrc = '{{ asset('images/Edtech-logo.png') }}';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                navbar.style.backgroundColor = 'white';
                navbar.style.color = 'black';

                navLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

                // Change the text color of language menu items to black
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });

 dropdown.forEach(function (link) {
                    link.style.color = 'black';
                });

 languageText.forEach(function (link) {
                    link.style.color = 'black';
                });

                logoImage.src = scrolledLogoSrc;
            } else {
                navbar.style.backgroundColor = 'black';
                navbar.style.color = 'white';
                navLinks.forEach(function (link) {
                    link.style.color = 'white';
                });

                // Change the text color of language menu items to white
                languageLinks.forEach(function (link) {
                    link.style.color = 'black';
                });
 dropdown.forEach(function (link) {
                    link.style.color = 'white';
                });
 languageText.forEach(function (link) {
                    link.style.color = 'white';
                });

                logoImage.src = initialLogoSrc;
            }
        });
    });

</script>

</body>
</html>